/*
 * Decompiled with CFR 0.152.
 */
package journeymap.compat.controlify;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.WaypointLayer;
import journeymap.client.ui.fullscreen.menu.FullScreenPopupMenu;
import journeymap.compat.controlify.Controlify;
import net.minecraft.class_2338;
import net.minecraft.class_437;

public class FullscreenProcessor
extends ScreenProcessor<Fullscreen> {
    public FullscreenProcessor(Fullscreen screen) {
        super((class_437)screen);
        this.addEventListener(new ScreenControllerEventListener(this){

            public void onControllerInput(ControllerEntity controller) {
                InputBinding up = Controlify.MAP_UP.on(controller);
                InputBinding down = Controlify.MAP_DOWN.on(controller);
                InputBinding left = Controlify.MAP_LEFT.on(controller);
                InputBinding right = Controlify.MAP_RIGHT.on(controller);
                float x = (right.analogueNow() - left.analogueNow()) * 16.0f;
                float y = (down.analogueNow() - up.analogueNow()) * 16.0f;
                if (x != 0.0f || y != 0.0f) {
                    UIManager.INSTANCE.getOrOpenFullscreenMap().moveCanvas(x, y);
                }
                if (Controlify.ZOOM_OUT.on(controller).justPressed()) {
                    UIManager.INSTANCE.getOrOpenFullscreenMap().zoomOut();
                }
                if (Controlify.ZOOM_IN.on(controller).justPressed()) {
                    UIManager.INSTANCE.getOrOpenFullscreenMap().zoomIn();
                }
                if (Controlify.CREATE_WAYPOINT.on(controller).justPressed()) {
                    UIManager.INSTANCE.getOrOpenFullscreenMap().createWaypointAtMouse();
                }
                if (Controlify.OPEN_CONTEXT.on(controller).justPressed()) {
                    Fullscreen fullscreenMap = UIManager.INSTANCE.getOrOpenFullscreenMap();
                    FullScreenPopupMenu popupMenu = fullscreenMap.popupMenu;
                    class_2338 blockCoord = fullscreenMap.getBlockAtMouse();
                    popupMenu.setClickLoc(fullscreenMap.mx, fullscreenMap.my);
                    if (WaypointLayer.selected != null) {
                        popupMenu.displayWaypointOptions(blockCoord, WaypointLayer.selected);
                    } else {
                        popupMenu.displayBasicOptions(blockCoord);
                    }
                    popupMenu.resetPass();
                }
            }
        });
    }

    protected HoldRepeatHelper createHoldRepeatHelper() {
        return new HoldRepeatHelper(0, 0);
    }

    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.ENABLED;
    }
}

